    <?php
        /**
        *
        * copyright (c) 2013-2023 Heliac Technologies
        * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
        *
        * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
        */
    ?>
    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#articoliPiuLetti">
                <a class="card-title">
                    Contenuti più letti
                </a>
            </div>
            <div id="articoliPiuLetti" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-7 col-lg-8 col-xl-9">Titolo</th>
                                    <th scope="col" class="col-4 col-lg-3 col-xl-2">Visite</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $risArticoli = $ricerca->eseguiRicerca(1);
                                    while($articolo = $risArticoli->fetch_assoc()) {
                                        $linkModificaContenuto = ($articolo["tipo"]=="elementoPortfolio") ? "componenti/portfolio/creaElemento.php" : "creaContenuto.php";
                                        echo"<tr class=\"d-flex\">
                                            <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$articolo["id"]}</th>
                                            <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"".$linkModificaContenuto."?id={$articolo["id"]}\">{$articolo["titolo"]} </a></td>
                                            <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$articolo["numeroVisite"]}</span></td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#piuCommentati">
                <a class="card-title">
                    Visualizzati oggi
                </a>
            </div>
            <div id="piuCommentati" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                  <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-7 col-lg-8 col-xl-9">Nome</th>
                                    <th scope="col" class="col-4 col-lg-3 col-xl-2">Visite</th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $ricerca->setParametriRicerca(array("dataUltimaVisita"=>date("Y-m-d")));
                                    $risDomandePiuLette = $ricerca->eseguiRicerca(1);
                                    while($risorsa = $risDomandePiuLette->fetch_assoc()) {
                                        $linkModificaContenuto = ($risorsa["tipo"]=="elementoPortfolio") ? "componenti/portfolio/creaElemento.php" : "creaContenuto.php";
                                        echo"<tr class=\"d-flex\">
                                            <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$risorsa["id"]}</th>
                                            <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"".$linkModificaContenuto."?id={$risorsa["id"]}\">{$risorsa["titolo"]} </a></td>
                                            <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$risorsa["numeroVisite"]}</span></td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>